/*----------------------------------------------------------------------------
 * Name:    BC7701.h
 * Purpose: BC7701 definitions
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef _BC7701_H_
#define _BC7701_H_

#include "ht32f520xx_01.h"

/*-------Handware interface define-----------------------------------------*/
#define	UART_TXD_PORT				HT_GPIOB
#define	UART_TXD						GPIO_PIN_15
#define	UART_TXD_AFIO_PORT		GPIO_PB
#define	UART_TXD_AFIO_FUN			AFIO_FUN_USART_UART

#define	UART_RXD_PORT				HT_GPIOC
#define	UART_RXD						GPIO_PIN_0
#define	UART_RXD_AFIO_PORT		GPIO_PC
#define	UART_RXD_AFIO_FUN			AFIO_FUN_USART_UART

#define	UART_WAKEUP_ESS_PORT		AFIO_ESS_PC             /* PORT C */
#define	UART_WAKEUP_EXIT_CH     AFIO_EXTI_CH_0				/* PC0 for UART RXD */

#define	RESET_PIN_PORT				HT_GPIOC
#define	RESET_PIN					GPIO_PIN_3
#define	RESET_AFIO_PORT			GPIO_PC
#define	RESET_AFIO_FUN				AFIO_FUN_GPIO

#define	UART_PORT					HT_USART1
#define 	UART_CLK(CK)    			(CK.Bit.USART1)
#define 	UART_IRQn      			(USART1_IRQn)
#define 	UART_IRQHandler 			(USART1_IRQHandler)
#define	UART_BAUD_RATE				115200
#define	UART_WORD_LENGTH			USART_WORDLENGTH_8B
#define	UART_STOP_BIT				USART_STOPBITS_1
#define	UART_PARITY					USART_PARITY_NO
#define	UART_MODE					USART_MODE_NORMAL
#define 	UART_BUFFER_SIZE   		64
/*----------------------------------------------------------------------------
 * BLE Controller Interface(BCI)
 *----------------------------------------------------------------------------*/
/* BCI Header type */
#define	BCI_CMD_PKG				0x77
#define	BCI_EVENT_PKG			0x78
#define	BCI_TYPE_LENG			2				/* BCI type + packet length=2byte */
#define	BCI_COMD_LENG			3           /* command flag+opcode=3byte */
#define	BCI_HEAD_LENG			BCI_TYPE_LENG+BCI_COMD_LENG

/* BCI OpCode */
#define	BCI_STATUS				0x0000		/* get BC7701 status */
#define	BCI_DISCONNECT			0x0002		/* disconnect current link */
#define	BCI_CONN_INTV			0x0003      /* modify connection interval */
#define	BCI_CONN_INTV1			0x0004      /* modify connection interval */
#define	BCI_DEV_NAME			0x0005      /* setup BLE device name */
#define	BCI_DEV_ADDRESS		0x0006      /* setup BLE device address */
#define	BCI_ADV_CTRL			0x0007      /* enable/disable BLE Adv */
#define	BCI_ADV_INTV			0x0008      /* setup Adv interval */
#define	BCI_ADV_DATA			0x0009      /* setup Adv data */
#define	BCI_SCAN_DATA			0x000A      /* setup scan data */
#define	BCI_TX_POWER			0x000B      /* setup TX power */
#define	BCI_CLOAD_SET			0x000E      /* setup crystal C-Load */
#define	BCI_PEER_DEV_ADDR		0x000F      /* get peer device address of connect */
#define	BCI_FEATURE_CTRL		0x0010
#define	BCI_VERSION				0x0020      /* get BC7701 F/W version */
#define	BCI_OPERATE_MODE		0x0025      /* set BC7701 operate mode mode */
#define	BCI_BAUDRATE			0x0026      /* setup BC7701 UART interface speed */
#define	BCI_BAUDRATE_MAX		0x0027      /* setup BC7701 UART interface speed to MAX*/
#define	BCI_SOFT_RESET			0x0028      /* BC7701 software reset */
#define	BCI_WHITE_LIST			0x002A      /* setup BC7701 white list */
#define	BCI_TEST_CTRL			0x00CC      /* for BC7701 RF test control */

/* BCI response Event status define */
#define	EVTS_SUCCESS			0x00
#define	EVTS_FAIL				0x01
#define	EVTS_UNKNOW				0x02
#define	EVTS_NOT_SUPPORT		0x03
#define	EVTS_PENDING			0x04
#define	EVTS_INVALID			0x05
#define	EVTS_NOT_ENABLE		0x06
#define	EVTS_FIFO_FULL			0x07
#define	EVTS_TIME_OUT			0x0E
#define	EVTS_CODE_MASK			0x0F

/*---------------------------------------------------------------------------- */
#define 	PACKAGE_MAX_SIZE		BCI_HEAD_LENG+128	/*type+length+flag+opcode=5bytes,payload max 128bytes */

/* BC7701 openate mode define */
#define	OP_NORMAL				0
#define	OP_DEEPSLEEP         1
#define	OP_POWERDOWN			2

/* device address type define */
#define	STATIC_ADDRESS			0
#define	RANDOM_ADDRESS       1

/* set advertising & scan data type */
#define	ADV_JOIN_NAME			0x00
#define	ADV_UNJOIN_NAME		0x10
#define	UPDAE_AUTO_NAME		0
#define	UPDAE_NOAO_NAME		1
#define	DEFAULT_NAME       	2
#define	DEFAULT_EMPTY			3


/* BCI package define */
typedef struct __attribute__((packed))
{
	u8		type;
	u8		length;
	u8		flag;
	u16   opcode;
	u8		param[];
}tBCI_PACKAGE;

/* status package define */
typedef union
{
	u32	u;
	struct
	{
		u32	Connect:1;							//b0
		u32	PramUpdateOk:1;               //b1
		u32	PramUpdataFail:1;             //b2
		u32	PramUpdataPeer:1;             //b3
		u32	CalibDone:1;		            //b4
		u32 	:3;                           //b5~b7
		u32	Ext32k:1;                     //b8
		u32	:23;                          //b9~b31
	}b;
}tSTATUS;

/* device address package define */
typedef struct __attribute__((packed))
{
	u8		adr[6];
	u8		type;
}tDEV_ADDR;

/* connect interval package define */
typedef struct __attribute__((packed))
{
	u16	min;
	u16	max;
	u16	latency;
	u16	timeout;
}tCNNT_INTV;

/* Advertising interval package define */
typedef struct __attribute__((packed))
{
	u16	min;
	u16	max;
	u8		map;
}tADV_INTV;

/* feature flag package define */
#define	FEATURE_DIR			1
#define	FEATURE_SET			2
#define	FEATURE_CLR			3

typedef enum
{
	FEATURE_NO_APPED_NAME =	(1UL << 2),
	FEATURE_PARAM_UPDATE	 =	(1UL << 4),
	FEATURE_PARAM_ERASE	 =	(1UL << 5),
	FEATURE_STATUS_EVENT	 =	(1UL << 7),
	FEATURE_CALIB_DONE	 =	(1UL << 9),
	FEATURE_EXTERNAL32K	 =	(1UL << 12),
	FEATURE_FORCE_CALIB	 =	(1UL << 25),
	FEATURE_CK32K_OUTPUT	 =	(1UL << 28)
} FeatureFlag;

typedef union
{
	u32	u;
	struct
	{
		u32	:1;						//b0
		u32	FFF0Parse:1;         //b1
		u32	AppendName:1;        //b2
		u32	:1;                  //b3
		u32	ParaUpdate:1;        //b4
		u32	ParaErase:1;         //b5
		u32	:1;                  //b6
		u32	SatusEvent:1;        //b7
		u32	:1;                  //b8
		u32	CalibDone:1;		   //b9
		u32 	:2;                  //b10~b11
		u32	External32k:1;       //b12
		u32 	:12;		            //b13~b24
		u32	ForceCalib:1;		   //b25
		u32	:2;                  //b26~b27
		u32	CK32Out:3;		      //b28~b30
		u32	:1;		            //b31
	}b;
}tFEATURE;

/* White list package define */
typedef struct __attribute__((packed))
{
	u8		adr[6];
	u8		mask[6];
}tWHITE_LIST;

enum
{
   BAUD_RATE_9600 = 0,
   BAUD_RATE_14400 = 1,
   BAUD_RATE_19200 = 2,
   BAUD_RATE_38400 = 3,
   BAUD_RATE_57600 = 4,
   BAUD_RATE_115200 = 5,
};

/* package parser step define*/
enum
{
   PARS_PKG_TYPE = 0x10,
   PARS_HCI_EVENT = 0x60,
   PARS_EVENT_LENG,
	PARS_EVENT_OPCODE,
   PARS_EVENT_PARAM
};

//extern u8	TransmitData[];
//extern u8	ReciveData[];

//#define	HCI_CMDPKGIDX	((tHCI_CMD_PKG *)&TransmitData)
//#define	HCI_EVTPKGIDX	((tHCI_EVENT_PKG *)&ReciveData)

//#define	BCI_TXPKGIDX	((tBCI_PACKAGE *)&TransmitData)
//#define	BCI_RXPKGIDX	((tBCI_PACKAGE *)&ReciveData)


void 	BC7701_InterfaceConfigure(u8 br);
void 	BC7701_UARTConfigure(u8 br);
void 	BC7701_RESET_SET(void);
void 	BC7701_RESET_CLR(void);
void 	BC7701_HardwareReset(void);
void 	BC7701_HardwareBaudRateDefault(u8 br);
void 	BC7701_HardwareBaudRateRelease(void);
void 	*BC7701_SoftwareReset(void);
void 	*BC7701_SoftwareResetKeep(void);
void 	*BC7701_SendHCIPackage(u16 opcode,u8 len,u8 *pbuf);
void 	*BC7701_SendBCIPackage(u16 opcode,u8 flag,u8 len,u8 *pbuf);
void 	*BC7701_SetDeviceName(u8 leng,u8 *name);
void 	*BC7701_SetDeviceAddress(u8 *adr,u8 type);
void 	*BC7701_ConnectIntervalModify(u16 opcode,u16 min,u16 max);
void 	*BC7701_SetAdvertisingData(u8 mode,u8 leng,u8 *advdata);
void 	*BC7701_SetScanResponseData(u8 leng,u8 *sdata);
void	*BC7701_AdvertisingInterval(u16 min,u16 max,u8 chmap);
void	*BC7701_AdvertisingControl(ControlStatus ctrl);
void	*BC7701_SetTxPower(u8 pwr);
void	*BC7701_SetCrystalCload(u8 cc);
void	*BC7701_SetupFeatureFlag(u8 md,FeatureFlag sff);
void	*BC7701_SetOperateMode(u8 omd,ControlStatus ctrl,u8 wuw,u8 wut);
void	*BC7701_SetWhiteList(ControlStatus erase,u8 *adr,u8 *mask);
void	*BC7701_SetBaudRate(u8 br);
bool 	BC7701_DummyWakeup(void);
bool 	BC7701_TransmitPackage(void *pbuf);
bool 	BC7701_ReadTransmitEmpty(void);
bool 	BC7701_ReadReceiveEmpty(void);
void 	*BC7701_ReadReceivePackage(void);
void 	BC7701_ReceiveParserPackage(void);
/*------------------------------------------------------------------------------
* Function Name : BC7701_SendBCIReadPackage
* Description   : send BCI read command to BC7701
* Input         :
*				- opcode : BCI command
*				- flag : BCI package flag
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
#define	BC7701_SendBCIReadPackage(opcode,flag) BC7701_SendBCIPackage(opcode,flag,0x00,NULL)
/*------------------------------------------------------------------------------
* Function Name : BC7701_DisconnectCmd
* Description   : send disconnect command to BC7701
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
#define	BC7701_DisconnectCmd()	BC7701_SendBCIPackage(BCI_DISCONNECT,0x00,0x00,NULL)

#endif
